package ru.yandex.solomon.codec.serializer.array;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.bits.BitArray;
import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.bits.HeapBitBuf;
import ru.yandex.solomon.codec.serializer.SelfContainedSerializer;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public abstract class BitBufSerializer implements SelfContainedSerializer<BitBuf> {
    public static final BitBufSerializer I = new ImplV1();

    private static final class ImplV1 extends BitBufSerializer {
        @Override
        public void serializeWithLength(BitBuf buffer, StockpileSerializer serializer) {
            long bits = buffer.readableBits();
            serializer.writeFixed64(bits);
            int bytes = buffer.bytesSize();
            serializer.writeBytes(buffer.array(), buffer.arrayOffset(), bytes);
        }

        @Override
        public BitBuf deserializeWithLength(StockpileDeserializer deserializer) {
            long bits = deserializer.readFixed64();
            int bytes = BitArray.arrayLengthForBits(bits);
            var array = deserializer.readBytes(bytes);
            return new HeapBitBuf(array, bits);
        }
    }
}
