package ru.yandex.solomon.codec.serializer.naked;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

import ru.yandex.solomon.codec.serializer.StockpileDeserializer;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface NakedDeserializer<A> {
    A deserializeToEofImpl(StockpileDeserializer deserializer);

    default A deserializeToEof(StockpileDeserializer deserializer) {
        A r = deserializeToEofImpl(deserializer);
        if (!deserializer.atEof()) {
            throw new IllegalStateException("expecting EOF while parsing " + this + "; pos: " + deserializer.pos()+ "; remaining: " + deserializer.remaining());
        }
        return r;

    }

    default A deserializeFull(byte[] bytes) {
        return deserializeRange(bytes, 0, bytes.length);
    }

    default A deserializeFullVerbose(byte[] bytes, String file) {
        try {
            return deserializeFull(bytes);
        } catch (Exception e) {
            throw new RuntimeException("failed to deserialize file: " + file, e);
        }
    }

    default A deserializeRange(byte[] bytes, int offset, int length) {
        StockpileDeserializer deserializer = new StockpileDeserializer(bytes, offset, length);
        return deserializeToEof(deserializer);
    }

    default A deserializeParts(byte[][] bytess) {
        StockpileDeserializer deserializer = StockpileDeserializer.concat(bytess);
        return deserializeToEof(deserializer);
    }

    default A deserializeParts(ByteString[] parts) {
        StockpileDeserializer deserializer = StockpileDeserializer.concat(parts);
        return deserializeToEof(deserializer);
    }

}
