package ru.yandex.solomon.codec.serializer.naked;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

import ru.yandex.solomon.codec.serializer.HeapStockpileSerializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface NakedSerializer<A> extends NakedDeserializer<A> {

    void serializeToEof(A a, StockpileSerializer serializer);

    default byte[] serializeToBytes(A a) {
        var serializer = new HeapStockpileSerializer();
        serializeToEof(a, serializer);
        return serializer.build();
    }

    default ByteString serializeToByteString(A a) {
        var serializer = new HeapStockpileSerializer();
        serializeToEof(a, serializer);
        return serializer.buildByteString();
    }
}
