package ru.yandex.solomon.codec.serializer.naked;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.reflection.TypeX;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class NakedSerializerLookup {

    @Nullable
    public static <A> NakedSerializer<A> lookupForVersionIndependentSerializer(TypeX type) {
        Class<?> clazz = type.erasure().getClazz();

        try {
            if (clazz.isAnnotationPresent(NakedSerializerImpl.class)) {
                NakedSerializerImpl annotation = clazz.getAnnotation(NakedSerializerImpl.class);
                return (NakedSerializer<A>) annotation.value().newInstance();
            } else {
                return null;
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

}
