package ru.yandex.solomon.math;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.algo.BinarySearch;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayListOrView;
import ru.yandex.solomon.model.timeseries.GraphData;
import ru.yandex.solomon.util.collection.array.LongArrayView;
import ru.yandex.solomon.util.time.Interval;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class Crop {
    private Crop() {
    }

    // For test only, used in Razladki-wow
    @Nonnull
    public static GraphData crop(GraphData graphData, Interval intervalInclusive) {
        return crop(graphData.toAggrGraphDataArrayList(), intervalInclusive).toGraphDataShort();
    }

    @Nonnull
    public static AggrGraphDataArrayListOrView crop(AggrGraphDataArrayListOrView graphData, Interval intervalInclusive) {
        if (graphData.isEmpty()) {
            return graphData;
        }

        LongArrayView timestamps = graphData.getTimestamps();

        if (timestamps.isEmpty()) {
            return graphData;
        }

        long beginMillis = intervalInclusive.getBeginMillis();
        long endMillis = intervalInclusive.getEndMillis();

        int firstIndex = getFirstIndex(timestamps, beginMillis);
        int lastIndex = getLastIndex(timestamps, endMillis);

        if (lastIndex - firstIndex == timestamps.length()) {
            return graphData;
        }

        return graphData.slice(firstIndex, lastIndex);
    }

    private static int getFirstIndex(LongArrayView timestamps, long beginMillis) {
        if (timestamps.first() >= beginMillis) {
            return 0;
        }
        if (timestamps.length() == 1 || timestamps.at(1) >= beginMillis) {
            return 1;
        }
        return BinarySearch.firstIndex(timestamps.length(), i -> timestamps.at(i) >= beginMillis);
    }

    private static int getLastIndex(LongArrayView timestamps, long endMillis) {
        if (timestamps.last() <= endMillis) {
            return timestamps.length();
        }
        return BinarySearch.firstIndex(timestamps.length(), i -> timestamps.at(i) > endMillis);
    }
}
