package ru.yandex.solomon.math;

import ru.yandex.solomon.model.timeseries.GraphData;
import ru.yandex.solomon.model.timeseries.SortedOrCheck;
import ru.yandex.solomon.util.collection.array.DoubleArrayView;

/**
 * @author Vladimir Gordiychuk
 */
public class Diff {
    /**
     * Delta value between points for a given metric
     */
    public static GraphData deltaValues(GraphData source) {
        long[] timestamps = source.getTimestamps().drop(1).copyToArray();
        double[] values = new double[timestamps.length];
        DoubleArrayView sourceValues = source.getValues();
        for (int i = 0; i < timestamps.length; ++i) {
            double diff = sourceValues.at(i + 1) - sourceValues.at(i);
            values[i] = diff;
        }

        return new GraphData(timestamps, values, SortedOrCheck.SORTED_UNIQUE);
    }
}
