package ru.yandex.solomon.math;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;

import ru.yandex.solomon.model.point.column.ValueView;
import ru.yandex.solomon.model.timeseries.GraphData;
import ru.yandex.solomon.util.collection.array.LongArrayView;

/**
 * @author Vladimir Gordiychuk
 */
@NotThreadSafe
@ParametersAreNonnullByDefault
public class GraphDataTimePointIterator {
    private final ValueView valueView;
    private final LongArrayView timeView;

    private int pos = -1;

    public GraphDataTimePointIterator(GraphData graphData) {
        this.valueView = graphData.getValuesView();
        this.timeView = graphData.getTimestamps();
    }

    public boolean hasNext(long pointMillis) {
        long nextTimeMillis;
        while (pos + 1 < timeView.length()) {
            pos++;
            nextTimeMillis = timeView.at(pos);

            if (nextTimeMillis == pointMillis) {
                return true;
            }

            if (nextTimeMillis > pointMillis) {
                pos--;
                return false;
            }
        }

        return false;
    }

    public double next() {
        return valueView.getValueNum(pos);
    }
}
