package ru.yandex.solomon.math;

import javax.annotation.Nonnull;

import ru.yandex.solomon.model.timeseries.GraphData;
import ru.yandex.solomon.model.timeseries.Timeline;

/**
 * @author Vladimir Gordiychuk
 */
public final class Resampler {
    private Resampler() {
    }

    public static GraphData resample(GraphData graphData, @Nonnull Timeline timeline) {
        return resample(graphData, timeline, Interpolate.NONE);
    }

    public static GraphData resample(GraphData graphData, @Nonnull Timeline timeline, Interpolate interpolate) {
        if (graphData.getTimeline().equals(timeline)) {
            return graphData;
        }

        GraphDataAsFunction function = new GraphDataAsFunction(graphData, interpolate);

        double[] values = new double[timeline.getPointCount()];

        for (int i = 0; i < timeline.getPointCount(); ++i) {
            long leftTsMillis = timeline.getPointMillisAt(i == 0 ? i : i - 1);
            long tsMillis = timeline.getPointMillisAt(i);
            long rightTsMillis = timeline.getPointMillisAt(i == (timeline.getPointCount() - 1) ? i : i + 1);

            double value = function.computeAt(leftTsMillis, tsMillis, rightTsMillis);
            values[i] = value;
        }

        return new GraphData(timeline, values);
    }
}
