package ru.yandex.solomon.math.doubles;

import java.util.Optional;

/**
 * @author Vladimir Gordiychuk
 */
public enum AggregateFunctionType {
    DEFAULT,
    MAX,
    MIN,
    AVG,
    SUM,
    LAST,
    STD,
    COUNT,
    INTEGRATE,
    MEDIAN,
    ;

    public static Optional<AggregateFunctionType> byName(String name) {
        for (AggregateFunctionType type : values()) {
            if (type.name().equalsIgnoreCase(name)) {
                return Optional.of(type);
            }
        }
        return Optional.empty();
    }
}
