package ru.yandex.solomon.math.doubles;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.timeseries.view.DoubleTimeSeriesView;
import ru.yandex.solomon.util.collection.array.DoubleArrayView;
import ru.yandex.solomon.util.collection.array.LongArrayView;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class DefaultDoubleTimeSeriesView implements DoubleTimeSeriesView {
    private final DoubleArrayView valueView;
    private final LongArrayView timeView;

    public DefaultDoubleTimeSeriesView(LongArrayView timeView, DoubleArrayView valueView) {
        if (timeView.length() != valueView.length()) {
            throw new IllegalArgumentException("Views size should be the same, but time view length " +
                timeView.length() +
                " value view length " +
                valueView.length()
            );
        }

        this.timeView = timeView;
        this.valueView = valueView;
    }

    @Nonnull
    @Override
    public LongArrayView getTimeView() {
        return timeView;
    }

    @Nonnull
    @Override
    public DoubleArrayView getValueView() {
        return valueView;
    }

    @Override
    public long getTsMillis(int index) {
        return timeView.at(index);
    }

    @Override
    public double getValue(int index) {
        return valueView.at(index);
    }

    @Override
    public int length() {
        return timeView.length();
    }

    @Nonnull
    @Override
    public DoubleTimeSeriesView slice(int from, int to) {
        return new DefaultDoubleTimeSeriesView(timeView.slice(from, to), valueView.slice(from, to));
    }
}
