package ru.yandex.solomon.math.doubles;

import ru.yandex.solomon.model.point.column.StockpileColumn;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayListOrView;
import ru.yandex.solomon.model.timeseries.GraphData;
import ru.yandex.solomon.model.timeseries.view.AggrGraphDataDoubleTimeSeriesView;
import ru.yandex.solomon.model.timeseries.view.DoubleTimeSeriesView;
import ru.yandex.solomon.util.collection.array.DoubleArrayView;
import ru.yandex.solomon.util.collection.array.LongArrayView;

/**
 * @author Vladimir Gordiychuk
 */
public final class DoubleTimeSeriesFactory {

    private DoubleTimeSeriesFactory() {
    }

    public static DoubleTimeSeriesView fromGraphData(GraphData graphData) {
        return fromView(graphData.getTimestamps(), graphData.getValues());
    }

    public static DoubleTimeSeriesView fromGraphData(MetricType dataType, AggrGraphDataArrayListOrView source) {
        if (source.hasColumn(StockpileColumn.TS) && source.hasColumn(StockpileColumn.VALUE)) {
            return new AggrGraphDataDoubleTimeSeriesView(source);
        }

        return fromGraphData(source.toGraphDataShort(dataType));
    }

    public static DoubleTimeSeriesView fromView(LongArrayView timestamps, DoubleArrayView values) {
        return new DefaultDoubleTimeSeriesView(timestamps, values);
    }
}
