package ru.yandex.solomon.math.operation;

import javax.annotation.Nullable;

import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.solomon.model.timeseries.aggregation.TimeseriesSummary;
import ru.yandex.stockpile.api.EProjectId;

/**
 * @author Vladimir Gordiychuk
 */
public class Metric<Key> {
    /**
     * Type of metric, after apply transform operation type can be changed
     */
    private MetricType type;
    /**
     * Owner subsystem
     */
    private EProjectId ownerProject;

    /**
     * By default contains identity of timeseries and equal to null only in case
     * when timeseries was combine with another one.
     */
    @Nullable
    private Key key;

    /**
     * Null only if was explicitly call drop timeseries, for example when required
     * only timeseries summary
     */
    @Nullable
    private AggrGraphDataIterable timeseries;

    /**
     * By default null, and filled only when summary explicitly requested
     */
    @Nullable
    private TimeseriesSummary summary;

    public Metric(Key key, MetricType type, AggrGraphDataIterable timeseries) {
        this(key, type, timeseries, null);
    }

    public Metric(Key key, MetricType type, EProjectId ownerProject, AggrGraphDataIterable timeseries) {
        this(key, type, ownerProject, timeseries, null);
    }

    public Metric(Key key, MetricType type, AggrGraphDataIterable timeseries, TimeseriesSummary summary) {
        this(key, type, EProjectId.UNKNOWN, timeseries, summary);
    }

    public Metric(Key key, MetricType type, EProjectId ownerProject, AggrGraphDataIterable timeseries, TimeseriesSummary summary) {
        this.key = key;
        this.type = type;
        this.ownerProject = ownerProject;
        this.timeseries = timeseries;
        this.summary = summary;
    }

    @Nullable
    public AggrGraphDataIterable getTimeseries() {
        return timeseries;
    }

    @Nullable
    public TimeseriesSummary getSummary() {
        return summary;
    }

    @Nullable
    public Key getKey() {
        return key;
    }

    public MetricType getType() {
        return type;
    }

    public EProjectId getOwnerProject() {
        return ownerProject;
    }

    public Metric<Key> dropTimeseries() {
        return new Metric<>(key, type, ownerProject,null, summary);
    }

    public Metric<Key> withTimeseries(@Nullable AggrGraphDataIterable timeseries) {
        return new Metric<>(key, type, ownerProject, timeseries, summary);
    }

    public Metric<Key> withTimeseries(MetricType type, @Nullable AggrGraphDataIterable timeseries) {
        return new Metric<>(key, type, ownerProject, timeseries, summary);
    }

    public Metric<Key> withSummary(@Nullable TimeseriesSummary summary) {
        return new Metric<>(key, type, ownerProject, timeseries, summary);
    }

    public Metric<Key> withKey(@Nullable Key key) {
        return new Metric<>(key, type, ownerProject, timeseries, summary);
    }

    @Override
    public String toString() {
        return "Sensor{type=" + type + ", key=" + key + ", ownerProjectId= " + ownerProject + ", timeseries=" + timeseries + ", summary=" + summary + '}';
    }
}
