package ru.yandex.solomon.math.operation;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.solomon.math.protobuf.Operation;
import ru.yandex.solomon.math.protobuf.OperationCombine;

/**
 * @author Vladimir Gordiychuk
 */
public class Operations {
    public static SplittedOperations splitOperations(List<Operation> operations) {
        if (operations.isEmpty()) {
            return SplittedOperations.EMPTY;
        }

        List<Operation> clientOps = new ArrayList<>(operations.size());
        List<Operation> serverOps = new ArrayList<>(operations.size());

        split:
        for (int index = 0; index < operations.size(); index++) {
            Operation op = operations.get(index);
            switch (op.getTypeCase()) {
                case DOWNSAMPLING:
                case DROP_TIMESERIES:
                case SUMMARY:
                case CAST:
                    serverOps.add(op);
                    break;
                case COMBINE: {
                    if (isSupportPushDown(op.getCombine())) {
                        serverOps.add(op);
                    }

                    clientOps.addAll(operations.subList(index, operations.size()));
                    break split;
                }
                case TOP: {
                    serverOps.add(op);
                    clientOps.addAll(operations.subList(index, operations.size()));
                    break split;
                }
                default:
                    throw new UnsupportedOperationException("Unsupported operation: " + op);
            }
        }

        return new SplittedOperations(clientOps, serverOps);
    }

    private static boolean isSupportPushDown(OperationCombine op) {
        switch (op.getAggregation()) {
            case LAST:
            case COUNT:
            case MAX:
            case MIN:
            case SUM:
                return true;
            default:
                return false;
        }
    }
}
