package ru.yandex.solomon.math.operation;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

import ru.yandex.misc.concurrent.CompletableFutures;
import ru.yandex.solomon.math.operation.map.MapOperation;
import ru.yandex.solomon.math.operation.reduce.ReduceOperation;

import static java.util.stream.Collectors.collectingAndThen;
import static java.util.stream.Collectors.toList;

/**
 * @author Vladimir Gordiychuk
 */
public class OperationsPipelineMap<Key> extends OperationsPipeline<Key> {
    private final List<CompletableFuture<Metric<Key>>> source;

    public OperationsPipelineMap(List<CompletableFuture<Metric<Key>>> source) {
        this.source = source;
    }

    @Override
    public <T> CompletableFuture<List<T>> collect(Function<Metric<Key>, T> mapping) {
        return source.stream()
                .map(future -> future.thenApply(mapping))
                .collect(collectingAndThen(toList(), CompletableFutures::allOf))
                .thenApply(Function.identity());
    }

    @Override
    protected OperationsPipeline<Key> thenMap(MapOperation<Key> map) {
        return source.stream()
                .map(future -> future.thenApply(map))
                .collect(collectingAndThen(toList(), OperationsPipelineMap::new));
    }

    @Override
    protected OperationsPipeline<Key> thenReduce(ReduceOperation<Key> reduce) {
        return new OperationsPipelineReduced<>(CompletableFutures.allOf(source)
                .thenApply(reduce::apply));
    }
}
