package ru.yandex.solomon.math.operation;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

import ru.yandex.solomon.math.operation.map.MapOperation;
import ru.yandex.solomon.math.operation.reduce.ReduceOperation;

import static java.util.stream.Collectors.toList;

/**
 * @author Vladimir Gordiychuk
 */
public class OperationsPipelineReduced<Key> extends OperationsPipeline<Key> {
    private CompletableFuture<List<Metric<Key>>> source;

    public OperationsPipelineReduced(CompletableFuture<List<Metric<Key>>> source) {
        this.source = source;
    }

    @Override
    public <T> CompletableFuture<List<T>> collect(Function<Metric<Key>, T> mapping) {
        return source.thenApply(list -> list.stream()
                .map(mapping)
                .collect(toList()));
    }

    protected OperationsPipeline<Key> thenMap(MapOperation<Key> map) {
        return new OperationsPipelineReduced<>(source.thenApply(list -> list.stream()
                .map(map)
                .collect(toList())));
    }

    protected OperationsPipeline<Key> thenReduce(ReduceOperation<Key> reduce) {
        return new OperationsPipelineReduced<>(source.thenApply(reduce));
    }
}
