package ru.yandex.solomon.math.operation;

import java.util.Collections;
import java.util.List;

import ru.yandex.solomon.math.protobuf.Operation;

/**
 * @author Vladimir Gordiychuk
 */
public class SplittedOperations {
    public static final SplittedOperations EMPTY = new SplittedOperations(Collections.emptyList(), Collections.emptyList());

    private final List<Operation> clientOps;
    private final List<Operation> serverOps;

    public SplittedOperations(List<Operation> clientOps, List<Operation> serverOps) {
        this.clientOps = clientOps;
        this.serverOps = serverOps;
    }

    public List<Operation> getClientOps() {
        return clientOps;
    }

    public List<Operation> getServerOps() {
        return serverOps;
    }
}
