package ru.yandex.solomon.math.operation.comparation;

import java.util.Comparator;

import ru.yandex.solomon.model.type.Histogram;

/**
 * @author Vladimir Gordiychuk
 */
public class HistogramComparator implements Comparator<Histogram> {
    @Override
    public int compare(Histogram left, Histogram right) {
        int leftIndex = left.count();
        int rightIndex = right.count();

        while (rightIndex > 0 || leftIndex > 0) {
            leftIndex--;
            rightIndex--;

            while (leftIndex > 0 && left.value(leftIndex) == 0) {
                leftIndex--;
            }

            while (rightIndex > 0 && right.value(rightIndex) == 0) {
                rightIndex--;
            }

            int compare = Double.compare(left.upperBound(leftIndex), right.upperBound(rightIndex));
            if (compare == 0) {
                compare = Long.compare(left.value(leftIndex), right.value(rightIndex));
            }

            if (compare != 0) {
                return compare;
            }
        }

        return Integer.compare(leftIndex, rightIndex);
    }
}
