package ru.yandex.solomon.math.operation.comparation;

import java.util.Comparator;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.AggrPointData;
import ru.yandex.solomon.model.protobuf.MetricType;

/**
 * @author Vladimir Gordiychuk
 */
public class PointValueComparators {
    public static Comparator<AggrPoint> comparator(MetricType type) {
        switch (type) {
            case COUNTER:
            case DGAUGE:
            case IGAUGE:
            case RATE:
            case METRIC_TYPE_UNSPECIFIED:
                return Comparator.comparingDouble(AggrPointData::getValueDivided);
            case HIST:
            case HIST_RATE:
                return Comparator.comparing(point -> point.histogram, new HistogramComparator());
            case ISUMMARY:
                return Comparator.comparing(point -> point.summaryInt64, new SummaryInt64Comparator());
            case DSUMMARY:
                return Comparator.comparing(point -> point.summaryDouble, new SummaryDoubleComparator());
            default:
                throw new UnsupportedOperationException("Unsupported type for compare: " + type);
        }
    }
}
