package ru.yandex.solomon.math.operation.comparation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.bolts.function.forhuman.Comparator;
import ru.yandex.monlib.metrics.summary.SummaryDoubleSnapshot;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SummaryDoubleComparator implements Comparator<SummaryDoubleSnapshot> {

    @Override
    public int compare(SummaryDoubleSnapshot left, SummaryDoubleSnapshot right) {
        int compare;

        compare = Double.compare(left.getSum(), right.getSum());
        if (compare != 0) {
            return compare;
        }

        // left greater than right because same sum reached by less count of points
        compare = Long.compare(left.getCount(), right.getCount()) * -1;
        if (compare != 0) {
            return compare;
        }

        compare = Double.compare(left.getMax(), right.getMax());
        if (compare != 0) {
            return compare;
        }

        return Double.compare(left.getMin(), right.getMin());
    }
}
