package ru.yandex.solomon.math.operation.comparation;

import java.util.Comparator;

import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;

/**
 * @author Vladimir Gordiychuk
 */
public class SummaryInt64Comparator implements Comparator<SummaryInt64Snapshot> {

    @Override
    public int compare(SummaryInt64Snapshot left, SummaryInt64Snapshot right) {
        int compare;

        compare = Long.compare(left.getSum(), right.getSum());
        if (compare != 0) {
            return compare;
        }

        // left greater than right because same sum reached by less count of points
        compare = Long.compare(left.getCount(), right.getCount()) * -1;
        if (compare != 0) {
            return compare;
        }

        compare = Long.compare(left.getMax(), right.getMax());
        if (compare != 0) {
            return compare;
        }

        return Long.compare(left.getMin(), right.getMin());
    }
}
