package ru.yandex.solomon.math.operation.map;

import ru.yandex.solomon.math.protobuf.OperationDownsampling;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.PointValueCollector;
import ru.yandex.solomon.util.time.Interval;

/**
 * @author Vladimir Gordiychuk
 */
public class DownsamplingIterable implements AggrGraphDataIterable {
    private final int mask;
    private final AggrGraphDataIterable source;
    private final Interval interval;
    private final long stepMillis;
    private final PointValueCollector collector;
    private final OperationDownsampling.FillOption fillOpt;
    private final boolean ignoreMinStepMillis;

    public DownsamplingIterable(
        int mask,
        AggrGraphDataIterable source,
        Interval interval,
        long stepMillis,
        PointValueCollector collector,
        OperationDownsampling.FillOption fillOpt,
        boolean ignoreMinStepMillis)
    {
        this.mask = mask;
        this.source = source;
        this.interval = interval;
        this.stepMillis = stepMillis;
        this.collector = collector;
        this.fillOpt = fillOpt;
        this.ignoreMinStepMillis = ignoreMinStepMillis;
    }

    @Override
    public int getRecordCount() {
        return source.getRecordCount();
    }

    @Override
    public int elapsedBytes() {
        return source.elapsedBytes();
    }

    @Override
    public AggrGraphDataListIterator iterator() {
        return new DownsamplingIterator(mask, source.iterator(), interval, stepMillis, collector, fillOpt, ignoreMinStepMillis);
    }

    @Override
    public int columnSetMask() {
        return mask;
    }
}
