package ru.yandex.solomon.math.operation.map;

import javax.annotation.Nullable;

import ru.yandex.solomon.math.operation.Metric;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.solomon.model.timeseries.aggregation.TimeseriesSummary;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.summary.SummaryCollector;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.summary.SummaryCollectors;

/**
 * @author Vladimir Gordiychuk
 */
public class OperationAggregationSummary<Key> implements MapOperation<Key> {
    private final ru.yandex.solomon.math.protobuf.OperationAggregationSummary opts;

    public OperationAggregationSummary(ru.yandex.solomon.math.protobuf.OperationAggregationSummary opts) {
        this.opts = opts;
    }

    @Override
    public Metric<Key> apply(Metric<Key> source) {
        if (opts.getAggregationsCount() == 0) {
            return source;
        }

        AggrGraphDataIterable timeseries = source.getTimeseries();
        if (timeseries == null) {
            throw new IllegalArgumentException("Absent timeseries for summary: " + source);
        }

        return source.withSummary(compute(source.getType(), timeseries));
    }

    @Nullable
    private TimeseriesSummary compute(MetricType type, AggrGraphDataIterable timeseries) {
        SummaryCollector collector = SummaryCollectors.of(type, opts.getAggregationsList());

        AggrPoint point = new AggrPoint(timeseries.columnSetMask());
        AggrGraphDataListIterator it = timeseries.iterator();
        while (it.next(point)) {
            collector.append(point);
        }

        return collector.compute();
    }
}
