package ru.yandex.solomon.math.operation.map;

import ru.yandex.solomon.math.operation.Metric;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;
import ru.yandex.solomon.model.timeseries.MetricTypeTransfers;

/**
 * @author Vladimir Gordiychuk
 */
public class OperationCast<Key> implements MapOperation<Key> {
    private final ru.yandex.solomon.math.protobuf.OperationCast opts;

    public OperationCast(ru.yandex.solomon.math.protobuf.OperationCast opts) {
        this.opts = opts;
    }

    @Override
    public Metric<Key> apply(Metric<Key> source) {
        if (source.getType() == opts.getType() || source.getTimeseries() == null) {
            return source;
        }

        AggrGraphDataArrayList result = AggrGraphDataArrayList.of(
                MetricTypeTransfers.of(
                        source.getType(),
                        opts.getType(),
                        source.getTimeseries().iterator()));

        return source.withTimeseries(opts.getType(), result);
    }
}
