package ru.yandex.solomon.math.operation.map;

import ru.yandex.solomon.math.operation.Metric;
import ru.yandex.solomon.math.protobuf.Aggregation;
import ru.yandex.solomon.model.point.column.StockpileColumn;
import ru.yandex.solomon.model.point.column.StockpileColumns;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.PointValueCollector;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.PointValueCollectors;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.UgramPointValueCollectors;
import ru.yandex.solomon.util.time.Interval;
import ru.yandex.stockpile.api.EProjectId;

/**
 * @author Vladimir Gordiychuk
 */
public class OperationDownsampling<Key> implements MapOperation<Key> {
    private final Interval interval;
    private final ru.yandex.solomon.math.protobuf.OperationDownsampling opts;

    public OperationDownsampling(Interval interval, ru.yandex.solomon.math.protobuf.OperationDownsampling options) {
        this.interval = interval;
        this.opts = options;
    }

    @Override
    public Metric<Key> apply(Metric<Key> source) {
        if (opts.getGridMillis() == 0) {
            return source;
        }

        AggrGraphDataIterable timeseries = source.getTimeseries();
        if (timeseries == null) {
            throw new IllegalArgumentException("Absent timeseries for downsampling: " + source);
        }

        if (timeseries.getRecordCount() == 0) {
            return source;
        }

        PointValueCollector collector = collector(source.getOwnerProject(), source.getType(), opts.getAggregation());
        var it = new DownsamplingIterable(
                StockpileColumns.minColumnSet(source.getType()) | StockpileColumn.COUNT.mask(),
                timeseries,
                interval,
                opts.getGridMillis(),
                collector,
                opts.getFillOption(),
                opts.getIgnoreMinStepMillis());
        return source.withTimeseries(it);
    }

    private PointValueCollector collector(EProjectId projectId, MetricType type, Aggregation aggregation) {
        if (type == MetricType.HIST && EProjectId.GOLOVAN == projectId) {
            return UgramPointValueCollectors.ofHistogram(aggregation);
        }

        return PointValueCollectors.of(type, aggregation);
    }
}
