package ru.yandex.solomon.math.operation.reduce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import ru.yandex.solomon.math.operation.Metric;
import ru.yandex.solomon.math.protobuf.Aggregation;
import ru.yandex.solomon.model.point.column.StockpileColumn;
import ru.yandex.solomon.model.point.column.StockpileColumns;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.PointValueCollector;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.PointValueCollectors;

/**
 * @author Vladimir Gordiychuk
 */
public class OperationCombine<Key> implements ReduceOperation<Key> {
    private final ru.yandex.solomon.math.protobuf.OperationCombine opts;

    public OperationCombine(ru.yandex.solomon.math.protobuf.OperationCombine opts) {
        this.opts = opts;
    }

    public List<Metric<Key>> apply(List<Metric<Key>> source) {
        if (source.isEmpty() || (source.size() == 1 && ableToSkip(opts.getAggregation()))) {
            return source;
        }

        List<AggrGraphDataListIterator> iterators = new ArrayList<>(source.size());
        MetricType lastType = MetricType.METRIC_TYPE_UNSPECIFIED;
        for (Metric read : source) {
            AggrGraphDataIterable timeseries = read.getTimeseries();
            if (timeseries == null) {
                throw new IllegalArgumentException("Absent timeseries for combine: " + source);
            }

            MetricType type = read.getType();
            if (lastType != MetricType.METRIC_TYPE_UNSPECIFIED && type != lastType) {
                throw new IllegalArgumentException("Not able combine diff metric type: " + lastType + ", " + type);
            }
            lastType = type;

            iterators.add(timeseries.iterator());
        }

        PointValueCollector collector = PointValueCollectors.of(lastType, opts.getAggregation());
        AggrGraphDataListIterator it = CombineIterator.of(resultMask(lastType), iterators, collector);
        return Collections.singletonList(new Metric<>(null, lastType, AggrGraphDataArrayList.of(it)));
    }

    private int resultMask(MetricType type) {
        return StockpileColumns.minColumnSet(type) | StockpileColumn.COUNT.mask();
    }

    private boolean ableToSkip(Aggregation aggregation) {
        return aggregation != Aggregation.COUNT;
    }
}
