package ru.yandex.solomon.math.stat;

import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.solomon.model.timeseries.MetricTypeTransfers;
import ru.yandex.solomon.model.timeseries.iterator.AggrPointCursor;

/**
 * @author Ivan Tsybulin
 */
public class HistogramBucketCursor extends AggrPointCursor {
    private final double bucketLimit;

    private static AggrGraphDataListIterator dgaugeIterator(MetricType dataType, AggrGraphDataIterable gd) {
        if (gd.isEmpty()) {
            return AggrGraphDataArrayList.empty().iterator();
        }
        return MetricTypeTransfers.of(dataType, MetricType.DGAUGE, gd.iterator());
    }

    public HistogramBucketCursor(double bucketLimit, MetricType dataType, AggrGraphDataIterable gd) {
        super(dgaugeIterator(dataType, gd));
        this.bucketLimit = bucketLimit;
    }

    public double getBucketLimit() {
        return bucketLimit;
    }
}
