package ru.yandex.solomon.math.stat;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.type.Histogram;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
class HistogramLikeFactory {
    private HistogramLikeFactory() {
    }

    static HistogramLike ofLegacy(LegacyHistogramPoint point) {
        return new HistogramLike() {
            @Override
            public int count() {
                return point.bucketLimits.length;
            }

            @Override
            public double value(int bucket) {
                return point.bucketValues[bucket];
            }

            @Override
            public double upperBound(int bucket) {
                return point.bucketLimits[bucket];
            }
        };
    }

    static HistogramLike ofHist(Histogram histogram) {
        return new HistogramLike() {
            @Override
            public int count() {
                return histogram.count();
            }

            @Override
            public double value(int bucket) {
                return histogram.valueDivided(bucket);
            }

            @Override
            public double upperBound(int bucket) {
                return histogram.upperBound(bucket);
            }
        };
    }
}
