package ru.yandex.solomon.math.stat;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.HasMutableTs;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class LegacyHistogramPoint implements HasMutableTs {
    public long tsMillis;
    public double[] bucketValues;
    public double[] bucketLimits;

    @Override
    public long getTsMillis() {
        return tsMillis;
    }

    @Override
    public void setTsMillis(long tsMillis) {
        this.tsMillis = tsMillis;
    }

    public void copyValues(double[] bucketValues) {
        if (this.bucketValues == null) {
            this.bucketValues = new double[bucketValues.length];
        }
        System.arraycopy(bucketValues, 0, this.bucketValues, 0, bucketValues.length);
    }
}
