package ru.yandex.solomon.math.stat;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.timeseries.GraphData;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class MovingAverage {
    private MovingAverage() {
    }

    /**
     * Simple moving average (SMA) is the unweighted mean of the previous N data inside interval.
     */
    public static GraphData simple(GraphData graphData, Duration window) {
        return MovingSumOrAvg.simpleAvg(graphData, window);
    }
}
