package ru.yandex.solomon.math.stat;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.timeseries.GraphData;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class MovingSum {
    private MovingSum() {
    }

    /**
     * Simple moving sum (SMS) is the sum of the previous N data inside interval.
     */
    public static GraphData simple(GraphData graphData, Duration window) {
        return MovingSumOrAvg.simpleSum(graphData, window);
    }
}

