package ru.yandex.solomon.math.stat;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class OnlineStatistics {
    private double mean = 0;
    private double sumDevSquared = 0;
    private int count = 0;

    // Welford's algorithm for one-pass variance computation
    void update(double val) {
        count++;
        double delta = val - mean;
        mean += delta / count;
        double delta2 = val - mean;
        sumDevSquared += delta * delta2;
    }

    double getVariance() {
        if (count <= 1) {
            return Double.NaN;
        }
        return sumDevSquared / (count - 1);
    }

    double getMean() {
        if (count < 1) {
            return Double.NaN;
        }
        return mean;
    }
}
