package ru.yandex.solomon.math.stat;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.math.GraphDataTimePointIterator;
import ru.yandex.solomon.model.timeseries.GraphData;
import ru.yandex.solomon.model.timeseries.Timeline;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class OverLinePercentile {
    private OverLinePercentile() {
    }

    /**
     * Iterates over point on time line and calculate percentile on each point base on values at this point.
     *
     * @param source     data to aggregate into single time series
     * @param percentile value of percentile
     * @throws IllegalArgumentException if specified graph data have different timeline
     */
    public static GraphData percentileOnParticularTime(Collection<GraphData> source, Timeline commonTimeLine, double percentile) {
        if (source.isEmpty()) {
            return GraphData.empty;
        }

        if (source.size() == 1) {
            return source.iterator().next();
        }

        GraphDataTimePointIterator[] valueIterators = source.stream()
            .map(GraphDataTimePointIterator::new)
            .toArray(GraphDataTimePointIterator[]::new);

        double[] result = new double[commonTimeLine.length()];
        double[] work = new double[source.size()];
        //todo replace it
        PercentileInplace calculator = new PercentileInplace();
        for (int index = 0; index < commonTimeLine.length(); index++) {
            int workSize = 0;
            long pointMillis = commonTimeLine.getPointMillisAt(index);

            for (GraphDataTimePointIterator it : valueIterators) {
                if (!it.hasNext(pointMillis)) {
                    continue;
                }

                double value = it.next();
                if (Double.isNaN(value)) {
                    continue;
                }

                work[workSize++] = value;
            }

            double target = calculator.evaluate(work, 0, workSize, percentile);
            result[index] = target;
        }

        return new GraphData(commonTimeLine, result);
    }
}
