package ru.yandex.solomon.math.stat;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
class PartialOrderer {
    /**
     * Reorders elements in [first, last) slice of <code>values</code> so that the slice
     * is partitioned around <code>low</code> and <code>high</code> elements.
     */
    public static void reorderOutliers(double[] values, int first, int last, int low, int high) {
        if (first > last)
            throw new IllegalArgumentException("Invalid range, first = " + first + " > " +
                                               last + " = last");
        if (first < 0 || last > values.length)
            throw new ArrayIndexOutOfBoundsException("Invalid range, [" + first + ", " + last +
                                                 ") is not a subset of [0, " + values.length + ")");

        if (low < first)
            throw new ArrayIndexOutOfBoundsException("Invalid lower quantille, low = " + low +
                                                " when slice first = " + first);
        if (high >= last)
            throw new ArrayIndexOutOfBoundsException("Invalid upper quantille, high = " + high +
                                                " when slice last = " + last);

        if (low > high)
            throw new IllegalArgumentException("The lower quantille low = " + low +
                                               " is greater than the upper one high = " + high);

        QuickSelect cachingSelector = new QuickSelect();

        // We cannot use cache here: the select ranges differ, so pivots will differ too.
        // Ranges cannot be the same, since otherwise the second select may shift the
        // elements before low+1 elsewhere.
        cachingSelector.select(values, first, last-first, false, low);
        if (high != low)
            cachingSelector.select(values, low+1, last-low-1, false, high);
    }
}
