package ru.yandex.solomon.math.stat;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SampleBucket extends OutlierFilter {

    private double mean = Double.NaN;
    private double variance = Double.NaN;

    public void processFiltered(final double[] data, int size, int leftMargin, int rightMargin) {
        OnlineStatistics stats = new OnlineStatistics();

        for (int i = leftMargin; i <= rightMargin; i++) {
            stats.update(data[i]);
        }

        this.mean = stats.getMean();
        this.variance = stats.getVariance();
    }

    public SampleBucket() {
        this(0);
    }

    public SampleBucket(double dropFraction) {
        super(dropFraction);
    }

    public double getMean() {
        process();
        return mean;
    }

    public double getVariance() {
        process();
        return variance;
    }
}
