package ru.yandex.solomon.math.stat;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SampleBucketWithUnfilteredStats extends OutlierFilter {

    private double mean = Double.NaN;
    private double variance = Double.NaN;
    private double unfilteredMean = Double.NaN;
    private double unfilteredVariance = Double.NaN;

    public void processFiltered(final double[] data, int size, int leftMargin, int rightMargin) {
        OnlineStatistics stats = new OnlineStatistics();

        for (int i = leftMargin; i <= rightMargin; i++) {
            stats.update(data[i]);
        }

        this.mean = stats.getMean();
        this.variance = stats.getVariance();

        for (int i = 0; i < leftMargin; i++) {
            stats.update(data[i]);
        }
        for (int i = rightMargin + 1; i < size; i++) {
            stats.update(data[i]);
        }

        this.unfilteredMean = stats.getMean();
        this.unfilteredVariance = stats.getVariance();
    }

    public SampleBucketWithUnfilteredStats() {
        this(0);
    }

    public SampleBucketWithUnfilteredStats(double dropFraction) {
        super(dropFraction);
    }

    public double getMean() {
        process();
        return mean;
    }

    public double getVariance() {
        process();
        return variance;
    }

    public double getUnfilteredMean() {
        process();
        return unfilteredMean;
    }

    public double getUnfilteredVariance() {
        process();
        return unfilteredVariance;
    }
}
