package ru.yandex.solomon.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class MetricKeyPartial {

    private final String name;
    private final Labels labels;

    public MetricKeyPartial(String name, Labels labels) {
        this.name = name;
        this.labels = labels;
    }

    public String getName() {
        return name;
    }

    public Labels getLabels() {
        return labels;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MetricKeyPartial that = (MetricKeyPartial) o;

        if (!name.equals(that.name)) return false;
        return labels.equals(that.labels);
    }

    @Override
    public int hashCode() {
        int result = name.hashCode();
        result = 31 * result + labels.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "MetricKeyPartial{name='" + name + "', labels=" + labels + '}';
    }
}
