package ru.yandex.solomon.model;

/**
 * @author Sergey Polovko
 */
public class StockpileKey {
    private final String destination;
    private final int shardId;
    private final long localId;

    public StockpileKey(String destination, int shardId, long localId) {
        this.destination = destination;
        this.shardId = shardId;
        this.localId = localId;
    }

    public String getDestination() {
        return destination;
    }

    public int getShardId() {
        return shardId;
    }

    public long getLocalId() {
        return localId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        StockpileKey that = (StockpileKey) o;

        if (shardId != that.shardId) return false;
        if (localId != that.localId) return false;
        return destination.equals(that.destination);
    }

    @Override
    public int hashCode() {
        int result = destination.hashCode();
        result = 31 * result + shardId;
        result = 31 * result + (int) (localId ^ (localId >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return destination + ":" + shardId + "/" + Long.toUnsignedString(localId);
    }
}
