package ru.yandex.solomon.model.array.mh.compact;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.commune.mh.builder.MhCall;
import ru.yandex.commune.mh.builder.MhExpr;
import ru.yandex.commune.mh.builder.MhExprObjects;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class CompactArrays {

    @Nonnull
    public static IllegalArgumentException unknownArrayType(Object array) {
        return new IllegalArgumentException("unknown array type: " + array.getClass().getName());
    }

    public static int hashCodeLikeInArray(int hashCode, int from, int to) {
        int length = to - from;

        int result = 1;
        for (int i = 0; i < length; ++i) {
            result = 31 * result + hashCode;
        }

        return result;
    }

    @Nonnull
    public static MhExpr hashCodeOfRangeConstant(MhExpr constants, MhExpr from, MhExpr to) {
        MhExpr hashCode = MhExprObjects.hashCode(constants);
        return MhCall.staticMethod(
            CompactArrays.class,
            "hashCodeLikeInArray",
            hashCode, from, to);
    }
}
