package ru.yandex.solomon.model.point;

import java.lang.invoke.MethodHandle;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.commune.mh.builder.MhBuilder;
import ru.yandex.commune.mh.builder.MhConst;
import ru.yandex.commune.mh.builder.MhExpr;
import ru.yandex.commune.mh.builder.MhFieldRef;
import ru.yandex.commune.mh.builder.misc.MhEqBuilder;
import ru.yandex.commune.mh.builder.misc.MhHashCodeBuilder;
import ru.yandex.commune.mh.builder.misc.MhStringBuilder;
import ru.yandex.monlib.metrics.summary.SummaryDoubleSnapshot;
import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;
import ru.yandex.solomon.model.point.column.HistogramColumn;
import ru.yandex.solomon.model.point.column.LogHistogramColumn;
import ru.yandex.solomon.model.point.column.StockpileColumn;
import ru.yandex.solomon.model.point.column.StockpileColumnField;
import ru.yandex.solomon.model.point.column.StockpileColumnFieldMh;
import ru.yandex.solomon.model.point.column.StockpileColumnSetTypeMh;
import ru.yandex.solomon.model.point.column.SummaryDoubleColumn;
import ru.yandex.solomon.model.point.column.SummaryInt64Column;
import ru.yandex.solomon.model.point.column.ValueColumn;
import ru.yandex.solomon.model.point.column.ValueObject;
import ru.yandex.solomon.model.type.Histogram;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Stepan Koltsov
 */
public class AggrPointData {

    @StockpileColumnField.A(StockpileColumnField.TS)
    public long tsMillis;
    @StockpileColumnField.A(StockpileColumnField.VALUE_NUM)
    public double valueNum;
    @StockpileColumnField.A(StockpileColumnField.VALUE_DENOM)
    public long valueDenom;
    @StockpileColumnField.A(StockpileColumnField.MERGE)
    public boolean merge;
    @StockpileColumnField.A(StockpileColumnField.COUNT)
    public long count;
    @StockpileColumnField.A(StockpileColumnField.STEP)
    public long stepMillis;
    @StockpileColumnField.A(StockpileColumnField.LOG_HISTOGRAM)
    public LogHistogram logHistogram;
    @StockpileColumnField.A(StockpileColumnField.HISTOGRAM)
    public Histogram histogram;
    @StockpileColumnField.A(StockpileColumnField.ISUMMARY)
    public SummaryInt64Snapshot summaryInt64;
    @StockpileColumnField.A(StockpileColumnField.DSUMMARY)
    public SummaryDoubleSnapshot summaryDouble;
    @StockpileColumnField.A(StockpileColumnField.LONG_VALUE)
    public long longValue;

    public AggrPointData() {
    }

    public AggrPointData(
        long tsMillis,
        double valueNum,
        long valueDenom,
        boolean merge,
        long count,
        long stepMillis,
        @Nullable LogHistogram logHistogram,
        @Nullable Histogram histogram,
        @Nullable SummaryInt64Snapshot summaryInt64,
        @Nullable SummaryDoubleSnapshot summaryDouble,
        long longValue)
    {
        this.tsMillis = tsMillis;
        this.valueNum = valueNum;
        this.valueDenom = valueDenom;
        this.merge = merge;
        this.count = count;
        this.stepMillis = stepMillis;
        this.logHistogram = logHistogram;
        this.histogram = histogram;
        this.summaryInt64 = summaryInt64;
        this.summaryDouble = summaryDouble;
        this.longValue = longValue;
    }

    public AggrPointData(AggrPointData copy) {
        this.tsMillis = copy.tsMillis;
        this.valueNum = copy.valueNum;
        this.valueDenom = copy.valueDenom;
        this.merge = copy.merge;
        this.count = copy.count;
        this.stepMillis = copy.stepMillis;
        this.logHistogram = LogHistogramColumn.copy(copy.logHistogram);
        this.histogram = HistogramColumn.copy(copy.histogram);
        this.summaryInt64 = SummaryInt64Column.copy(copy.summaryInt64);
        this.summaryDouble = SummaryDoubleColumn.copy(copy.summaryDouble);
        this.longValue = copy.longValue;
    }

    public long getTsMillis() {
        return tsMillis;
    }

    public double getValueNum() {
        return valueNum;
    }

    public long getValueDenom() {
        return valueDenom;
    }

    public boolean isMerge() {
        return merge;
    }

    public long getCount() {
        return count;
    }

    public long getStepMillis() {
        return stepMillis;
    }

    public ValueObject getValueObject() {
         return new ValueObject(valueNum, valueDenom);
    }

    public double getValueDivided() {
        return ValueColumn.divide(valueNum, valueDenom);
    }

    private static final MethodHandle toStringHelper =
        MhBuilder.oneshot1(
            AggrPointData.class,
            point -> {
                ArrayList<MhExpr> params = new ArrayList<>();
                params.add(MhConst.auto("AggrPointData{"));

                for (StockpileColumn c : StockpileColumn.values()) {
                    if (c.ordinal() != 0) {
                        params.add(MhConst.auto(", "));
                    }
                    params.add(MhConst.auto(c.nameLc + "="));
                    List<MhExpr> value = c.mh().getField(point);
                    MhExpr valueString = c.mh().toString(value);
                    params.add(valueString);
                }

                params.add(MhConst.auto("}"));

                return MhStringBuilder.toStringAndConcat(params.toArray(new MhExpr[0]));
            });

    @Override
    public String toString() {
        try {
            return (String) toStringHelper.invokeExact(this);
        } catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static final MethodHandle eq = MhEqBuilder.buildEq(AggrPointData.class);
    private static final MethodHandle hc = MhHashCodeBuilder.buildHashCode(AggrPointData.class);

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != AggrPointData.class) {
            return false;
        }
        try {
            return (boolean) eq.invokeExact(this, (AggrPointData) obj);
        } catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public int hashCode() {
        try {
            return (int) hc.invokeExact(this);
        } catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @Nonnull
    public Instant getTs() {
        return Instant.ofEpochMilli(getTsMillis());
    }

    private static final MethodHandle clearFieldsByMask =
        MhBuilder.oneshot2(
            AggrPointData.class, StockpileColumnSetTypeMh.primitiveClass,
            (pointData, clearMask) -> {
                return StockpileColumnFieldMh.invokeAllExprs(d -> {
                    MhFieldRef fieldRef = d.mh().fieldForColumn(pointData);
                    MhExpr set = fieldRef.set(d.mh().defaultValue());
                    MhExpr cond = d.column.mh().isInSet(clearMask);
                    return set.onlyIf(cond);
                });
            });

    public void clearFieldDataByMask(int clearMask) {
        try {
            clearFieldsByMask.invokeExact(this, clearMask);
        } catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}
