package ru.yandex.solomon.model.point;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.commune.mh.builder.MhCall;
import ru.yandex.commune.mh.builder.MhExpr;
import ru.yandex.solomon.model.point.column.StockpileColumnFieldMh;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
final class AggrPointMh {
    private AggrPointMh() {
    }

    @Nonnull
    public static MhExpr newInstance(MhExpr columnSet, List<MhExpr> values) {
        ArrayList<MhExpr> a = new ArrayList<>();
        a.add(columnSet);
        a.addAll(values);
        return MhCall.newInstance(AggrPoint.class, a);
    }

    @Nonnull
    public static MhExpr copyOf(MhExpr columnSetMask, MhExpr valuesSource) {
        return newInstance(columnSetMask, StockpileColumnFieldMh.getFieldsFilterByMask(valuesSource, columnSetMask));
    }
}
