package ru.yandex.solomon.model.point;

import java.util.DoubleSummaryStatistics;
import java.util.LongSummaryStatistics;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;

import ru.yandex.monlib.metrics.summary.ImmutableSummaryDoubleSnapshot;
import ru.yandex.monlib.metrics.summary.ImmutableSummaryInt64Snapshot;
import ru.yandex.monlib.metrics.summary.SummaryDoubleSnapshot;
import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;
import ru.yandex.solomon.model.type.Histogram;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Vladimir Gordiychuk
 */
public class AggrPoints {
    public static AggrPoint point(String time, double value) {
        return AggrPoint.builder()
                .time(time)
                .doubleValue(value)
                .build();
    }

    public static AggrPoint point(long ts, double value) {
        return AggrPoint.builder()
                .time(ts)
                .doubleValue(value)
                .build();
    }

    public static AggrPoint point(String time, double value, long count) {
        return AggrPoint.builder()
                .time(time)
                .doubleValue(value)
                .count(count)
                .build();
    }

    public static AggrPoint point(long time, double value, long count) {
        return AggrPoint.builder()
                .time(time)
                .doubleValue(value)
                .count(count)
                .build();
    }

    public static AggrPoint point(long ts, double sum, boolean merge, long count) {
        return AggrPoint.builder()
                .time(ts)
                .doubleValue(sum)
                .merge(merge)
                .count(count)
                .build();
    }

    public static AggrPoint point(long ts, double sum, boolean merge, long count, long stepMillis) {
        return AggrPoint.builder()
                .time(ts)
                .doubleValue(sum)
                .merge(merge)
                .count(count)
                .stepMillis(stepMillis)
                .build();
    }

    public static AggrPoint dpoint(String ts, double sum, boolean merge, long count, long stepMillis) {
        return AggrPoint.builder()
                .time(ts)
                .doubleValue(sum)
                .merge(merge)
                .count(count)
                .stepMillis(stepMillis)
                .build();
    }

    public static AggrPoint point(String ts, double sum, boolean merge, long count) {
        return AggrPoint.builder()
                .time(ts)
                .doubleValue(sum)
                .merge(merge)
                .count(count)
                .build();
    }

    public static AggrPoint lpoint(String time, long value) {
        return AggrPoint.builder()
                .time(time)
                .longValue(value)
                .build();
    }

    public static AggrPoint lpoint(long time, long value) {
        return AggrPoint.builder()
                .time(time)
                .longValue(value)
                .build();
    }

    public static AggrPoint lpoint(String time, long value, long stepMillis) {
        return AggrPoint.builder()
                .time(time)
                .longValue(value)
                .stepMillis(stepMillis)
                .build();
    }

    public static AggrPoint dpoint(long time, double value, long stepMillis) {
        return AggrPoint.builder()
                .time(time)
                .doubleValue(value)
                .stepMillis(stepMillis)
                .build();
    }

    public static AggrPoint dpoint(long time, double value, boolean merged, long count) {
        return AggrPoint.builder()
            .time(time)
            .doubleValue(value)
            .merge(merged)
            .count(count)
            .build();
    }

    public static AggrPoint dpoint(long time, double value) {
        return AggrPoint.builder()
                .time(time)
                .doubleValue(value)
                .build();
    }

    public static AggrPoint dpoint(String time, double value) {
        return AggrPoint.builder()
            .time(time)
            .doubleValue(value)
            .build();
    }

    public static AggrPoint lpoint(long time, long value, long stepMillis) {
        return AggrPoint.builder()
                .time(time)
                .longValue(value)
                .stepMillis(stepMillis)
                .build();
    }

    public static AggrPoint lpoint(long time, long value, boolean merged, long count) {
        return AggrPoint.builder()
                .time(time)
                .longValue(value)
                .merge(merged)
                .count(count)
                .build();
    }

    public static AggrPoint lpoint(long time, long value, boolean merged, long count, long stepMillis) {
        return AggrPoint.builder()
                .time(time)
                .longValue(value)
                .merge(merged)
                .count(count)
                .stepMillis(stepMillis)
                .build();
    }

    public static AggrPoint lpoint(String time, long value, boolean merged, long count, long stepMillis) {
        return AggrPoint.builder()
            .time(time)
            .longValue(value)
            .merge(merged)
            .count(count)
            .stepMillis(stepMillis)
            .build();
    }

    public static AggrPoint lpoint(String time, long value, boolean merged, long count) {
        return AggrPoint.builder()
                .time(time)
                .longValue(value)
                .merge(merged)
                .count(count)
                .build();
    }

    public static AggrPoint point(String time, Histogram value) {
        return AggrPoint.builder()
                .time(time)
                .histogram(value)
                .build();
    }

    public static AggrPoint point(long time, Histogram value) {
        return AggrPoint.builder()
                .time(time)
                .histogram(value)
                .build();
    }

    public static AggrPoint pointWithStepMillis(String time, Histogram value, long stepMillis) {
        return AggrPoint.builder()
                .time(time)
                .histogram(value)
                .stepMillis(stepMillis)
                .build();
    }

    public static AggrPoint pointWithStepMillis(long time, Histogram value, long stepMillis) {
        return AggrPoint.builder()
                .time(time)
                .histogram(value)
                .stepMillis(stepMillis)
                .build();
    }

    public static AggrPoint point(long time, Histogram value, boolean merge, long count) {
        return AggrPoint.builder()
                .time(time)
                .histogram(value)
                .merge(merge)
                .count(count)
                .build();
    }

    public static AggrPoint point(String time, Histogram value, boolean merge, long count) {
        return AggrPoint.builder()
                .time(time)
                .histogram(value)
                .merge(merge)
                .count(count)
                .build();
    }

    public static AggrPoint point(long time, Histogram value, long count) {
        return AggrPoint.builder()
                .time(time)
                .histogram(value)
                .count(count)
                .build();
    }

    public static AggrPoint point(String time, Histogram value, long count) {
        return AggrPoint.builder()
                .time(time)
                .histogram(value)
                .count(count)
                .build();
    }

    public static AggrPoint point(String time, LogHistogram value) {
        return AggrPoint.builder()
                .time(time)
                .logHistogram(value)
                .build();
    }

    public static AggrPoint point(long time, LogHistogram value) {
        return AggrPoint.builder()
                .time(time)
                .logHistogram(value)
                .build();
    }

    public static AggrPoint pointWithStepMillis(String time, LogHistogram value, long stepMillis) {
        return AggrPoint.builder()
                .time(time)
                .logHistogram(value)
                .stepMillis(stepMillis)
                .build();
    }

    public static AggrPoint pointWithStepMillis(long time, LogHistogram value, long stepMillis) {
        return AggrPoint.builder()
                .time(time)
                .logHistogram(value)
                .stepMillis(stepMillis)
                .build();
    }

    public static AggrPoint point(String time, LogHistogram value, boolean merge, long count) {
        return AggrPoint.builder()
                .time(time)
                .logHistogram(value)
                .merge(merge)
                .count(count)
                .build();
    }

    public static AggrPoint point(long time, LogHistogram value, boolean merge, long count) {
        return AggrPoint.builder()
                .time(time)
                .logHistogram(value)
                .merge(merge)
                .count(count)
                .build();
    }

    public static AggrPoint point(String time, LogHistogram value, long count) {
        return AggrPoint.builder()
                .time(time)
                .logHistogram(value)
                .count(count)
                .build();
    }

    public static AggrPoint point(long time, LogHistogram value, long count) {
        return AggrPoint.builder()
                .time(time)
                .logHistogram(value)
                .count(count)
                .build();
    }

    public static AggrPoint point(String time, SummaryInt64Snapshot value) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .build();
    }

    public static AggrPoint point(long time, SummaryInt64Snapshot value) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .build();
    }

    public static AggrPoint pointWithStepMillis(String time, SummaryInt64Snapshot value, long stepMillis) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .stepMillis(stepMillis)
                .build();
    }

    public static AggrPoint pointWithStepMillis(long time, SummaryInt64Snapshot value, long stepMillis) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .stepMillis(stepMillis)
                .build();
    }

    public static AggrPoint point(String time, SummaryInt64Snapshot value, boolean merge, long count) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .merge(merge)
                .count(count)
                .build();
    }

    public static AggrPoint point(long time, SummaryInt64Snapshot value, boolean merge, long count) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .merge(merge)
                .count(count)
                .build();
    }

    public static AggrPoint point(String time, SummaryInt64Snapshot value, long count) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .count(count)
                .build();
    }

    public static AggrPoint point(long time, SummaryInt64Snapshot value, long count) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .count(count)
                .build();
    }

    public static AggrPoint point(String time, SummaryDoubleSnapshot value) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .build();
    }

    public static AggrPoint point(long time, SummaryDoubleSnapshot value) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .build();
    }

    public static AggrPoint point(String time, SummaryDoubleSnapshot value, long count) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .count(count)
                .build();
    }

    public static AggrPoint point(long time, SummaryDoubleSnapshot value, long count) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .count(count)
                .build();
    }

    public static AggrPoint pointWithStepMillis(String time, SummaryDoubleSnapshot value, long stepMillis) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .stepMillis(stepMillis)
                .build();
    }

    public static AggrPoint pointWithStepMillis(long time, SummaryDoubleSnapshot value, long stepMillis) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .stepMillis(stepMillis)
                .build();
    }

    public static AggrPoint point(String time, SummaryDoubleSnapshot value, boolean merge, long count) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .merge(merge)
                .count(count)
                .build();
    }

    public static AggrPoint point(long time, SummaryDoubleSnapshot value, boolean merge, long count) {
        return AggrPoint.builder()
                .time(time)
                .summary(value)
                .merge(merge)
                .count(count)
                .build();
    }

    public static Histogram dhistogram(double[] bounds, long[] buckets) {
        return Histogram.newInstance(bounds, buckets);
    }

    public static SummaryDoubleSnapshot summaryDouble(double... values) {
        DoubleSummaryStatistics summary = DoubleStream.of(values).summaryStatistics();
        return new ImmutableSummaryDoubleSnapshot(summary.getCount(), summary.getSum(), summary.getMin(), summary.getMax());
    }

    public static SummaryInt64Snapshot summaryInt64(long... values) {
        LongSummaryStatistics summary = LongStream.of(values).summaryStatistics();
        return new ImmutableSummaryInt64Snapshot(summary.getCount(), summary.getSum(), summary.getMin(), summary.getMax());
    }
}
