package ru.yandex.solomon.model.point;

import io.netty.util.Recycler;

/**
 * @author Vladimir Gordiychuk
 */
public class RecyclableAggrPoint extends AggrPoint {
    private static final Recycler<RecyclableAggrPoint> RECYCLER = new Recycler<>() {
        protected RecyclableAggrPoint newObject(Handle<RecyclableAggrPoint> handle) {
            return new RecyclableAggrPoint(handle);
        }
    };

    private final Recycler.Handle<RecyclableAggrPoint> handle;

    private RecyclableAggrPoint(Recycler.Handle<RecyclableAggrPoint> handle) {
        this.handle = handle;
    }

    public static RecyclableAggrPoint newInstance() {
        return RECYCLER.get();
    }

    public boolean recycle() {
        this.reset();
        this.handle.recycle(this);
        return true;
    }
}
