package ru.yandex.solomon.model.point.column;

import com.google.common.math.LongMath;

/**
 * @author Stepan Koltsov
 */
public class CountColumn extends ColumnImplBase {

    public static final CountColumn C = new CountColumn();

    public static final StockpileColumn column = StockpileColumn.COUNT;

    public static final long DEFAULT_VALUE = 0;

    public static final int mask = StockpileColumn.COUNT.mask();

    public CountColumn() {
        super(StockpileColumn.COUNT);
    }

    public static long merge(long a, long b) {
        // should probably return 0 if either is 0
        return LongMath.saturatedAdd(a, b);
    }

    public static String toString(long value) {
        return Long.toString(value);
    }

    public static void validateOrThrow(long count) {
        if (count < 0) {
            throw new IllegalArgumentException("invalid count: " + count);
        }
    }
}
