package ru.yandex.solomon.model.point.column;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface HasColumnSet {

    @StockpileColumnSetType
    int columnSetMask();

    default StockpileColumnSet columnSet() {
        return new StockpileColumnSet(columnSetMask());
    }

    default boolean hasColumn(StockpileColumn column) {
        return hasColumn(columnSetMask(), column);
    }

    static boolean hasColumn(int columnSetMask, StockpileColumn column) {
        return (columnSetMask & column.mask()) != 0;
    }

}
