package ru.yandex.solomon.model.point.column;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.type.LogHistogram;
import ru.yandex.solomon.model.type.MutableLogHistogram;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class LogHistogramColumn extends ColumnImplBase {

    private LogHistogramColumn() {
        super(StockpileColumn.LOG_HISTOGRAM);
    }

    public static final LogHistogramColumn C = new LogHistogramColumn();
    public static final LogHistogram DEFAULT_VALUE = null;
    public static final int mask = StockpileColumn.LOG_HISTOGRAM.mask();

    @Nullable
    public static LogHistogram merge(@Nullable LogHistogram left, @Nullable LogHistogram right) {
        if (left == null) {
            return right;
        }

        if (right == null) {
            return left;
        }

        MutableLogHistogram histogram = new MutableLogHistogram();
        histogram.addHistogram(left);
        histogram.addHistogram(right);

        return histogram.toImmutable();
    }

    public static LogHistogram copy(@Nullable LogHistogram histogram) {
        if (histogram == null) {
            return null;
        }

        return LogHistogram.copyOf(histogram);
    }

    public static LogHistogram copy(@Nullable LogHistogram source, @Nullable LogHistogram target) {
        if (source == null) {
            return null;
        }

        return LogHistogram.orNew(target).copyFrom(source);
    }

    public static void recycle(@Nullable LogHistogram target) {
        if (target == null) {
            return;
        }

        target.recycle();
    }

    public static String toString(@Nullable LogHistogram histogram) {
        return String.valueOf(histogram);
    }
}
