package ru.yandex.solomon.model.point.column;

/**
 * @author Vladimir Gordiychuk
 */
public class LongValueColumn extends ColumnImplBase {

    private LongValueColumn() {
        super(StockpileColumn.LONG_VALUE);
    }

    public static final LongValueColumn C = new LongValueColumn();
    public static final long DEFAULT_VALUE = 0;
    public static final int mask = StockpileColumn.LONG_VALUE.mask();

    public static long merge(long left, long right) {
        return left + right;
    }

    public static void validateOrThrow(long value) {
    }

    public static String toString(long longValue) {
        return Long.toUnsignedString(longValue);
    }
}
