package ru.yandex.solomon.model.point.column;

import java.util.Random;

/**
 * @author Vladimir Gordiychuk
 */
public class LongValueRandomData {
    private static final RandomLongFunction[] FUNCTIONS = {
            random -> random.nextBoolean() ? 0 : 1,
            Random::nextInt,
            random -> random.nextInt(200) - 100,
            Random::nextLong,
            random -> Long.MAX_VALUE,
            random -> Long.MIN_VALUE,
            random -> Long.MIN_VALUE + random.nextLong()
    };

    public static long randomLongValue(Random random) {
        return FUNCTIONS[random.nextInt(FUNCTIONS.length)].apply(random);
    }

    private interface RandomLongFunction {
        long apply(Random random);
    }
}
