package ru.yandex.solomon.model.point.column;

import java.lang.invoke.MethodHandle;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class MergeColumn extends ColumnImplBase {

    public static final MergeColumn C = new MergeColumn();

    public static final StockpileColumn column = StockpileColumn.MERGE;

    public static final boolean DEFAULT_VALUE = false;
    public static final int mask = StockpileColumn.MERGE.mask();

    private MergeColumn() {
        super(StockpileColumn.MERGE);
    }

    /**
     * Merge 'merge' column.
     */
    public static boolean merge(boolean a, boolean b) {
        return b && a;
    }

    public static String toString(boolean value) {
        return Boolean.toString(value);
    }

    private static class GetOptional {
        private static final MethodHandle mh = column.singleDataField().arrayLikeMh().getIfNotEmptyOrDefault();
    }

    public static boolean getOptional(Object merges, int index) {
        try {
            return (boolean) GetOptional.mh.invokeExact(merges, index);
        } catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static class CopyOf {
        private static final MethodHandle mh = column.singleDataField().arrayLikeMh().copyOfToRegularArrayIfNotEmpty();
    }

    public static boolean[] copyOf(Object merges, int size) {
        try {
            return (boolean[]) CopyOf.mh.invokeExact(merges, size);
        } catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void validateOrThrow(boolean merge) {
        // NOP
    }
}
