package ru.yandex.solomon.model.point.column;

import java.lang.invoke.MethodHandle;

import ru.yandex.solomon.util.time.DurationUtils;

/**
 * @author Stepan Koltsov
 *
 * https://st.yandex-team.ru/SOLOMON-1352
 */
public class StepColumn extends ColumnImplBase {

    public static final StepColumn C = new StepColumn();

    public static final StockpileColumn column = StockpileColumn.STEP;

    public static final int mask = StockpileColumn.STEP.mask();

    /** Infinite */
    public static final long DEFAULT_VALUE = 0;

    private StepColumn() {
        super(StockpileColumn.STEP);
    }

    public static long merge(long a, long b) {
        return b;
    }

    public static String toString(long step) {
        if (step == 0) {
            return "0";
        } else {
            return DurationUtils.millisToSecondsString(step);
        }
    }


    public static void validateOrThrow(long stepMillis) {
        if (stepMillis < 0) {
            throw new RuntimeException("Negative step is not allowed");
        }
    }

    private static class CopyOf {
        private static final MethodHandle mh = column.singleDataField().arrayLikeMh().copyOfToRegularArrayIfNotEmpty();
    }

    public static long[] copyOf(Object stepMillis, int size) {
        try {
            return (long[]) CopyOf.mh.invokeExact(stepMillis, size);
        } catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}
