package ru.yandex.solomon.model.point.column;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.type.array.ArrayType;
import ru.yandex.bolts.type.array.ObjectArrayType;
import ru.yandex.monlib.metrics.summary.SummaryDoubleSnapshot;
import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;
import ru.yandex.solomon.model.array.mh.ArrayLikeFieldMh;
import ru.yandex.solomon.model.type.Histogram;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public enum StockpileColumnField {
    TS(StockpileColumn.TS, false, false, Cf.LongArray),
    VALUE_NUM(StockpileColumn.VALUE, false, false, Cf.DoubleArray),
    VALUE_DENOM(StockpileColumn.VALUE, true, false, Cf.LongArray),
    MERGE(StockpileColumn.MERGE, true, false, Cf.BooleanArray),
    COUNT(StockpileColumn.COUNT, false, false, Cf.LongArray),
    STEP(StockpileColumn.STEP, true, false, Cf.LongArray),
    LOG_HISTOGRAM(StockpileColumn.LOG_HISTOGRAM, false, true, ObjectArrayType.forObjectElementType(LogHistogram.class)),
    HISTOGRAM(StockpileColumn.HISTOGRAM, false, true, ObjectArrayType.forObjectElementType(Histogram.class)),
    ISUMMARY(StockpileColumn.ISUMMARY, false, true, ObjectArrayType.forObjectElementType(SummaryInt64Snapshot.class)),
    DSUMMARY(StockpileColumn.DSUMMARY, false, true, ObjectArrayType.forObjectElementType(SummaryDoubleSnapshot.class)),
    LONG_VALUE(StockpileColumn.LONG_VALUE, false, false, Cf.LongArray),

    ;

    public final StockpileColumn column;
    public final String nameLc;
    public final boolean compactArrays;
    public final boolean mutable;
    public final ArrayType<?, ?> arrayType;

    StockpileColumnField(StockpileColumn column, boolean compactArrays, boolean mutable, ArrayType<?, ?> arrayType) {
        this.column = column;
        this.compactArrays = compactArrays;
        this.mutable = mutable;
        this.arrayType = arrayType;
        this.nameLc = name().toLowerCase();
    }

    public int indexInColumn() {
        return ordinal() - column.firstField().ordinal();
    }

    @Nonnull
    public Class<?> arrayOrCompactClass() {
        if (compactArrays) {
            return Object.class;
        } else {
            return arrayClass();
        }
    }

    @Nullable
    public Object defaultValue() {
        return arrayType.elementDefaultValue();
    }

    @Nonnull
    public Class<?> arrayClass() {
        return arrayType.arrayClass();
    }

    @Nonnull
    public ArrayLikeFieldMh<?, ?> arrayLikeMh() {
        return ArrayLikeFieldMh.forArrayType(arrayType, compactArrays);
    }

    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.FIELD)
    public @interface A {
        StockpileColumnField value();
    }

    @Nonnull
    public StockpileColumnFieldMh mh() {
        return new StockpileColumnFieldMh(this);
    }
}
